/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.GrabItFrame;
import cds.aladin.GrabUtil;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanFree;
import cds.aladin.PlaneLoadEvent;
import cds.aladin.PlaneLoadListener;
import cds.aladin.SAMPUtil;
import cds.aladin.Save;
import cds.aladin.Server;
import cds.aladin.TapClient;
import cds.aladin.TapManager;
import cds.aladin.TapTable;
import cds.aladin.Tok;
import cds.tools.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

@Deprecated
public class FrameUploadServer
extends JFrame
implements ActionListener,
PlaneLoadListener,
GrabItFrame {
    private static final long serialVersionUID = 399753558953437543L;
    static String TITLE;
    static String CLOSE;
    static String ERRORMSG;
    static String IDENTIFIER;
    static String TAPTABLEUPLOADPARSETIP;
    static String UPFILEINFO;
    static String BROWSE;
    static String DISCARDALL;
    static String DISCARDALLTIP;
    static String NOTABLELOADEDMESSAGE;
    static String TABLEDISCARDINFO;
    static String NEWOPTIONADDEDMESSAGE;
    static String CHOOSELOCALFILEFORUPLOADLABEL;
    static String UPLOADEDFILESLABEL;
    static String BUTTONLABELLOADLOCALFILEUPLOADED;
    static String UPLOADTABLENAMETIPLABEL;
    static String UPLOADNOLOCALFILECHOSENEMESSAGE;
    static String TABLENAMEINPUTTIP;
    static String UPLOADINVALIDTABLENAME;
    static String UPLOADDPLICATETABLENAME;
    static String LOADUPLOADCLIENTTIP;
    static String UPLOADFILEBROWSERLABEL;
    private Aladin aladin;
    protected JComboBox<String> uploadOptions;
    protected Map<String, String> uploadTableNameDict = new HashMap<String, String>();
    TapClient uploadClient;
    GridBagConstraints c;
    JLabel infoLabel;
    JTextField systemFile;
    JComboBox<String> uploadAvailableServers;
    JPanel bottomButtonsPanel;
    private JLabel tableNameLabel;
    private JButton editButton;
    private AbstractButton expandCollapse;

    protected void createChaine() {
        TITLE = Aladin.chaine.getString("UPLOADTITLE");
        CLOSE = Aladin.chaine.getString("CLOSE");
        IDENTIFIER = Aladin.chaine.getString("ISIDENTIFIER");
        ERRORMSG = Aladin.chaine.getString("ERROR");
        TAPTABLEUPLOADPARSETIP = Aladin.chaine.getString("TAPTABLEUPLOADPARSETIP");
        UPFILEINFO = Aladin.chaine.getString("UPFILEINFO");
        BROWSE = Aladin.chaine.getString("FILEBROWSE");
        DISCARDALL = Aladin.chaine.getString("DISCARDALL");
        DISCARDALLTIP = Aladin.chaine.getString("DISCARDALLTIP");
        TABLEDISCARDINFO = Aladin.chaine.getString("TABLEDISCARDINFO");
        NEWOPTIONADDEDMESSAGE = Aladin.chaine.getString("NEWOPTIONADDEDMESSAGE");
        CHOOSELOCALFILEFORUPLOADLABEL = Aladin.chaine.getString("CHOOSELOCALFILEFORUPLOADLABEL");
        UPLOADEDFILESLABEL = Aladin.chaine.getString("UPLOADEDFILESLABEL");
        BUTTONLABELLOADLOCALFILEUPLOADED = Aladin.chaine.getString("BUTTONLABELLOADLOCALFILEUPLOADED");
        UPLOADTABLENAMETIPLABEL = Aladin.chaine.getString("UPLOADTABLENAMETIPLABEL");
        UPLOADNOLOCALFILECHOSENEMESSAGE = Aladin.chaine.getString("UPLOADNOLOCALFILECHOSENEMESSAGE");
        TABLENAMEINPUTTIP = Aladin.chaine.getString("TABLENAMEINPUTTIP");
        UPLOADINVALIDTABLENAME = Aladin.chaine.getString("UPLOADINVALIDTABLENAME");
        UPLOADDPLICATETABLENAME = Aladin.chaine.getString("UPLOADDPLICATETABLENAME");
        LOADUPLOADCLIENTTIP = Aladin.chaine.getString("LOADUPLOADCLIENTTIP");
        UPLOADFILEBROWSERLABEL = Aladin.chaine.getString("UPLOADFILEBROWSERLABEL");
    }

    protected FrameUploadServer(Aladin aladin, String mainServerUrl) {
        this.aladin = aladin;
        Aladin.setIcon(this);
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, aladin);
        this.uploadClient = TapClient.getUploadTapClient(aladin, "LocalResources", mainServerUrl);
        this.createChaine();
        this.setTitle(TITLE);
    }

    public void setGui() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setLocation(Aladin.computeLocation(this));
        this.setUploadFileForm();
        this.aladin.grabUtilInstance.grabItServers.add(this.uploadClient.serverTap);
    }

    protected void show(TapClient tapClient) {
        this.setTitle("Upload to " + tapClient.tapLabel);
        this.uploadClient.tapBaseUrl = tapClient.tapBaseUrl;
        this.setFont(Aladin.PLAIN);
        this.pack();
        this.setVisible(true);
    }

    public void setUploadFileForm() {
        this.getContentPane().setBackground(Aladin.COLOR_CONTROL_BACKGROUND);
        this.c = new GridBagConstraints();
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 3;
        this.c.fill = 0;
        this.c.anchor = 21;
        this.c.insets = new Insets(10, 10, 5, 5);
        JLabel l = new JLabel(UPFILEINFO);
        this.getContentPane().add((Component)l, this.c);
        ++this.c.gridy;
        this.c.gridx = 0;
        this.c.gridwidth = 1;
        this.c.insets = new Insets(1, 10, 1, 1);
        this.c.weightx = 0.04;
        this.getContentPane().add((Component)new JLabel(CHOOSELOCALFILEFORUPLOADLABEL), this.c);
        this.c.gridx = 1;
        this.c.weightx = 0.93;
        this.c.insets = new Insets(1, 1, 1, 1);
        this.systemFile = new JTextField();
        this.systemFile.setPreferredSize(new Dimension(240, Server.HAUT));
        this.c.anchor = 17;
        this.c.fill = 2;
        this.getContentPane().add((Component)this.systemFile, this.c);
        if (Aladin.STANDALONE) {
            JButton browse = new JButton(BROWSE);
            browse.addActionListener(this);
            this.c.fill = 0;
            this.c.anchor = 17;
            this.c.insets = new Insets(1, 3, 1, 5);
            this.c.weightx = 0.03;
            this.c.gridx = 2;
            this.getContentPane().add((Component)browse, this.c);
        }
        this.c.gridx = 0;
        this.c.gridwidth = 3;
        ++this.c.gridy;
        this.c.insets = new Insets(1, 3, 20, 5);
        this.c.fill = 0;
        this.c.anchor = 10;
        JButton button = new JButton(BUTTONLABELLOADLOCALFILEUPLOADED);
        button.setActionCommand("UPLOAD");
        button.addActionListener(this);
        button.setToolTipText(TAPTABLEUPLOADPARSETIP);
        this.getContentPane().add((Component)button, this.c);
        this.c.gridx = 0;
        ++this.c.gridy;
        this.infoLabel = new JLabel();
        this.infoLabel.setFont(Aladin.ITALIC);
        this.c.insets = new Insets(1, 10, 1, 1);
        this.getContentPane().add((Component)this.infoLabel, this.c);
        JPanel uploadableVoTablesPanel = this.getAllUploadableVoTablesPanel();
        ++this.c.gridy;
        this.c.gridwidth = 3;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.getContentPane().add((Component)uploadableVoTablesPanel, this.c);
        this.pack();
    }

    public JPanel getAllUploadableVoTablesPanel() {
        JPanel containerPanel = new JPanel(new GridBagLayout());
        containerPanel.setBorder(BorderFactory.createTitledBorder(UPLOADEDFILESLABEL));
        GridBagConstraints c = new GridBagConstraints();
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.48;
        c.insets = new Insets(2, 10, 5, 2);
        c.fill = 2;
        c.anchor = 17;
        boolean hasUploaded = false;
        this.initUploadParameters();
        Vector<String> canUploadVOTablesNames = new Vector<String>();
        canUploadVOTablesNames.addAll(this.uploadTableNameDict.keySet());
        if (canUploadVOTablesNames.isEmpty()) {
            this.uploadOptions = new JComboBox();
        } else {
            this.uploadOptions = new JComboBox(canUploadVOTablesNames);
            hasUploaded = true;
        }
        this.uploadOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameUploadServer.this.setStateForUploadedComponents();
            }
        });
        this.uploadOptions.setEnabled(hasUploaded);
        this.uploadOptions.setOpaque(false);
        containerPanel.add(this.uploadOptions, c);
        c.gridx = 1;
        c.weightx = 0.5;
        c.insets = new Insets(1, 5, 1, 1);
        c.fill = 0;
        this.tableNameLabel = new JLabel(UPLOADTABLENAMETIPLABEL);
        containerPanel.add((Component)this.tableNameLabel, c);
        c.gridx = 2;
        c.weightx = 0.01;
        c.insets = new Insets(1, 1, 1, 2);
        this.editButton = new JButton("EDIT");
        this.editButton.setActionCommand("EDITUPLOADTABLENAMEACTION");
        this.editButton.addActionListener(this);
        containerPanel.add((Component)this.editButton, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        c.insets = new Insets(10, 10, 5, 5);
        c.fill = 0;
        c.anchor = 17;
        Image image = Aladin.aladin.getImagette("Expand.png");
        this.expandCollapse = image != null ? new JButton(new ImageIcon(image)) : new JButton(">> load this table on tap client");
        this.expandCollapse.setToolTipText(LOADUPLOADCLIENTTIP);
        this.expandCollapse.setMargin(new Insets(0, 0, 0, 0));
        this.expandCollapse.setBorderPainted(false);
        this.expandCollapse.setContentAreaFilled(false);
        this.expandCollapse.setActionCommand("UPLOAD");
        this.expandCollapse.addActionListener(this);
        containerPanel.add((Component)this.expandCollapse, c);
        this.setStateForUploadedComponents();
        return containerPanel;
    }

    public void setStateForUploadedComponents() {
        boolean hasUploaded = false;
        if (this.uploadOptions.getItemCount() > 0) {
            hasUploaded = true;
            String tableNameTip = UPLOADTABLENAMETIPLABEL + " ";
            String tableName = this.uploadTableNameDict.get(this.uploadOptions.getSelectedItem());
            tableNameTip = tableNameTip + tableName;
            this.tableNameLabel.setText(tableNameTip);
        }
        this.uploadOptions.setEnabled(hasUploaded);
        this.tableNameLabel.setVisible(hasUploaded);
        this.editButton.setVisible(hasUploaded);
        this.expandCollapse.setVisible(hasUploaded);
    }

    public Vector<String> initUploadParameters() {
        PlanCatalog planCatalog = null;
        Vector<String> canUploadVOTablesNames = new Vector<String>();
        Plan[] plan = this.aladin.calque.plan;
        for (int i = 0; i < plan.length; ++i) {
            if (!plan[i].flagOk || plan[i].pcat == null || !(plan[i] instanceof PlanCatalog) || !plan[i].pcat.flagVOTable) continue;
            canUploadVOTablesNames.add(plan[i].label);
            String uploadTableName = this.generateSuffix();
            this.uploadTableNameDict.put(plan[i].label, uploadTableName);
            try {
                this.allowPlanIntoUploadFacade(plan[i]);
                planCatalog = (PlanCatalog)plan[i];
                this.updateUploadGuiWithNewUpload(planCatalog);
                continue;
            }
            catch (Exception e) {
                if (Aladin.levelTrace >= 3) {
                    e.printStackTrace();
                }
                Aladin.trace(3, "Unable to parse " + plan[i].label + " data for upload");
            }
        }
        return canUploadVOTablesNames;
    }

    public void addUploadToSubmitParams(List<String> referencedUploadTables, Map<String, Object> requestParams) throws Exception {
        StringBuffer uploadParam = null;
        for (String referencedTable : referencedUploadTables) {
            if (!this.uploadTableNameDict.containsValue(referencedTable)) continue;
            String uploadFileName = null;
            for (Map.Entry<String, String> entry : this.uploadTableNameDict.entrySet()) {
                if (!entry.getValue().equals(referencedTable)) continue;
                uploadFileName = entry.getKey();
                break;
            }
            if (uploadFileName != null) {
                if (uploadParam == null) {
                    uploadParam = new StringBuffer();
                } else {
                    uploadParam.append(";");
                }
                uploadParam.append(this.getUploadParam(referencedTable, uploadFileName));
            }
            if (requestParams == null || uploadParam == null || uploadFileName == null) continue;
            requestParams.put("UPLOAD", uploadParam.toString());
            File tmpFile = this.aladin.createTempFile(SAMPUtil.sanitizeFilename(referencedTable), ".xml");
            if (tmpFile == null) {
                Aladin.trace(3, "ERROR in aladin.createTempFile for " + uploadFileName);
                throw new Exception("Unable to parse " + uploadFileName + " data for upload!");
            }
            if (this.aladin.save == null) {
                this.aladin.save = new Save(this.aladin);
            }
            Plan plan = this.aladin.calque.getPlan(uploadFileName, 1);
            PlanCatalog planCatalog = (PlanCatalog)plan;
            this.aladin.save.saveCatVOTable(tmpFile, planCatalog, false, false);
            tmpFile.deleteOnExit();
            requestParams.put(uploadFileName, tmpFile);
        }
    }

    protected String getUploadParam(String tableName, String fileName) {
        return tableName.replace("TAP_UPLOAD.", "").concat(",param:").concat(fileName);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if (command.equals("SUBMIT")) {
            if (!this.uploadTableNameDict.containsValue(this.uploadClient.serverTap.selectedTableName)) {
                Aladin.error(this.getContentPane(), "Unable to submit " + this.uploadClient.serverTap.selectedTableName + " data!");
                return;
            }
            this.uploadClient.serverTap.submit();
            TapManager.getInstance(this.aladin).eraseNotification(this.infoLabel, "Submitting your query for table: " + this.uploadClient.serverTap.selectedTableName, "");
        } else if (command.equals("UPLOAD")) {
            if (this.checkInputs()) {
                return;
            }
            try {
                Plan loadingPlan = this.aladin.calque.createPlan(this.systemFile.getText().trim(), "localTableData", null, this.uploadClient.serverTap);
                loadingPlan.addPlaneLoadListener(this);
                if (loadingPlan instanceof PlanFree) {
                    Aladin.error(this.getContentPane(), "Unable to upload " + this.systemFile.getText().trim() + " data!");
                    return;
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace >= 3) {
                    e.printStackTrace();
                }
                Aladin.error(this.getContentPane(), "Error unable upload your data!\n" + e.getMessage());
            }
            this.pack();
        } else {
            if (command.equals(BROWSE)) {
                this.browseFile();
                return;
            }
            if (command.equals(CLOSE)) {
                this.setVisible(false);
            } else if (command.equals("EDITUPLOADTABLENAMEACTION")) {
                JTextField userInput = new JTextField();
                JLabel tip = new JLabel(TABLENAMEINPUTTIP);
                Object[] uploadTableName = new Object[]{"Upload table name:", userInput, tip};
                int option = JOptionPane.showConfirmDialog(this.getContentPane(), uploadTableName, "Edit upload table name", 2);
                if (option == 0) {
                    String tableNameConstr = userInput.getText();
                    if (tableNameConstr.isEmpty() || !this.isTableNameValid(tableNameConstr)) {
                        Aladin.error(this.getContentPane(), UPLOADINVALIDTABLENAME);
                        return;
                    }
                    tableNameConstr = "TAP_UPLOAD." + TapTable.getQueryPart(tableNameConstr, false);
                    if (this.tableAlreadyExists(tableNameConstr)) {
                        Aladin.error(this.getContentPane(), UPLOADDPLICATETABLENAME);
                        return;
                    }
                    String fileName = this.getCorrespondingUploadTableName((JButton)evt.getSource());
                    String oldTableName = this.uploadTableNameDict.get(fileName);
                    this.uploadTableNameDict.put(fileName, tableNameConstr);
                    this.setStateForUploadedComponents();
                    TapManager tapManager = TapManager.getInstance(this.aladin);
                    tapManager.changeUploadTableName(oldTableName, tableNameConstr, this.uploadClient.tablesMetaData);
                    tapManager.eraseNotification(this.infoLabel, "New table name: " + tableNameConstr + ", set for " + fileName, "");
                }
            }
        }
    }

    public String getCorrespondingUploadTableName(JButton button) {
        String result = null;
        JPanel wrapper = (JPanel)SwingUtilities.getAncestorOfClass(JPanel.class, button);
        if (wrapper != null) {
            block0: for (Component component : wrapper.getComponents()) {
                JComboBox tablesGui;
                String tableName;
                if (!(component instanceof JComboBox) || !component.getName().equals("table") || !this.uploadTableNameDict.containsValue(tableName = (String)(tablesGui = (JComboBox)component).getSelectedItem())) continue;
                for (Map.Entry<String, String> entry : this.uploadTableNameDict.entrySet()) {
                    if (!entry.getValue().equals(tableName)) continue;
                    result = entry.getKey();
                    break block0;
                }
            }
        }
        return result;
    }

    @Override
    public void planeLoaded(PlaneLoadEvent ple) {
        if (ple.status != PlaneLoadEvent.SUCCESS || !ple.plane.flagOk || ple.plane.pcat == null || !ple.plane.pcat.flagVOTable) {
            Aladin.trace(3, "Cannot load " + ple.plane.label + " data for upload. Error!");
            Aladin.error(this.getContentPane(), "Cannot load " + ple.plane.label + " data for upload. Error!");
        }
    }

    public void allowPlanIntoUploadFacade(Plan plan) throws Exception {
        if (!(plan instanceof PlanCatalog)) {
            throw new Exception("Cannot parse " + plan.label + " data for upload. Please select a catalog!");
        }
        String uploadTableName = this.generateSuffix();
        this.uploadTableNameDict.put(plan.label, uploadTableName);
    }

    public void updateUploadGuiWithNewUpload(PlanCatalog planCatalog) {
        if (this.uploadTableNameDict.containsKey(planCatalog.label)) {
            TapManager tapManager = TapManager.getInstance(this.aladin);
            String uploadTableName = this.uploadTableNameDict.get(planCatalog.label);
            tapManager.eraseNotification(this.infoLabel, "New table(Name: " + uploadTableName + ") from " + planCatalog.label + " is parsed in Aladin!", "");
        }
    }

    public void deleteAvailableUploadTable(Plan planInDeletion) {
        if (planInDeletion.pcat != null && planInDeletion.pcat.flagVOTable) {
            TapManager tapManager = TapManager.getInstance(this.aladin);
            String tableToDiscard = this.uploadTableNameDict.get(planInDeletion.label);
            this.uploadClient.tablesMetaData.remove(tableToDiscard);
            boolean enable = false;
            if (this.uploadClient.tablesMetaData != null && !this.uploadClient.tablesMetaData.isEmpty()) {
                enable = true;
                tapManager.uploadTablesModel.removeElement(tableToDiscard);
            }
            if (!enable) {
                this.clearBottomPanel();
            }
            this.uploadTableNameDict.remove(planInDeletion.label);
            this.setStateForUploadedComponents();
            if (this.isVisible()) {
                TapManager.getInstance(this.aladin).eraseNotification(this.infoLabel, TABLEDISCARDINFO, "");
                this.pack();
            }
        }
    }

    protected void createUploadServer() {
        this.uploadClient.preprocessTapClient();
        this.uploadClient.serverTap.setOpaque(true);
        this.uploadClient.serverTap.createFormDefault();
        this.c.insets = new Insets(5, 10, 10, 5);
        this.c.gridx = 0;
        ++this.c.gridy;
        this.c.gridwidth = 4;
        this.c.weighty = 0.94;
        this.c.fill = 1;
        this.c.anchor = 11;
        this.getContentPane().add((Component)this.uploadClient.serverTap, this.c);
        ++this.c.gridy;
        this.c.weighty = 0.01;
        this.c.fill = 0;
        this.c.anchor = 15;
        this.bottomButtonsPanel = new JPanel();
        JButton submit = new JButton("Submit");
        submit.addActionListener(this);
        submit.setActionCommand("SUBMIT");
        this.bottomButtonsPanel.add(submit);
        this.getContentPane().add((Component)this.bottomButtonsPanel, this.c);
        this.uploadClient.serverTap.revalidate();
        this.uploadClient.serverTap.repaint();
    }

    public void clearBottomPanel() {
        this.uploadClient.tablesMetaData.clear();
        this.uploadClient.serverTap.formLoadStatus = 0;
        if (this.uploadClient.serverTap.tablesGui != null) {
            this.uploadClient.serverTap.tablesGui.removeAllItems();
        }
        this.uploadClient.serverTap.removeAll();
        this.remove(this.uploadClient.serverTap);
        this.remove(this.bottomButtonsPanel);
        this.pack();
    }

    protected boolean checkInputs() {
        boolean hasError = true;
        if (this.systemFile.getText().trim().isEmpty()) {
            Aladin.error(this.getContentPane(), UPLOADNOLOCALFILECHOSENEMESSAGE);
        } else {
            hasError = false;
        }
        return hasError;
    }

    protected void browseFile() {
        File f;
        String path = Util.dirBrowser(UPLOADFILEBROWSERLABEL, this.aladin.getDefaultDirectory(), this.systemFile, 2);
        if (path == null) {
            return;
        }
        String dir = path;
        int offset = path.indexOf(" ");
        if (offset > 0) {
            Tok tok = new Tok(path, " ");
            dir = tok.nextToken();
        }
        if (!(f = new File(dir)).isDirectory()) {
            dir = f.getParent();
        }
        this.aladin.memoDefaultDirectory(dir);
    }

    public boolean tableAlreadyExists(String input) {
        return this.uploadTableNameDict.containsValue(input);
    }

    public boolean isTableNameValid(String input) {
        boolean result = false;
        Pattern regex = Pattern.compile("[^A-Za-z0-9]");
        Matcher matcher = regex.matcher(input);
        if (!matcher.find() && (matcher = (regex = Pattern.compile("[A-Za-z]")).matcher(input)).find()) {
            result = true;
        }
        return result;
    }

    public String generateUploadTableName(String prefix) {
        String uploadTableName = prefix + new Random().nextInt(31);
        if (!this.tableAlreadyExists(uploadTableName)) {
            return uploadTableName;
        }
        return this.generateUploadTableName(prefix);
    }

    private String generateSuffix() {
        String uploadTableSuffix = "AladinTable" + new Random().nextInt(31);
        String uploadTableName = "TAP_UPLOAD.".concat(uploadTableSuffix);
        if (!this.tableAlreadyExists(uploadTableName)) {
            return uploadTableName;
        }
        return this.generateSuffix();
    }

    @Override
    public void setGrabItCoord(Coord c) {
        GrabUtil.setGrabItCoord(this.aladin, this.uploadClient.serverTap, c);
    }

    @Override
    public void stopGrabIt() {
        GrabUtil.stopGrabIt(this.aladin, this, this.uploadClient.serverTap);
    }

    @Override
    public boolean isGrabIt() {
        return this.uploadClient.serverTap.modeCoo != 0 && this.uploadClient.serverTap.grab != null && this.uploadClient.serverTap.grab.getModel().isSelected();
    }

    @Override
    public void setGrabItRadius(double x1, double y1, double x2, double y2) {
        GrabUtil.setGrabItRadius(this.aladin, this.uploadClient.serverTap, x1, y1, x2, y2);
    }
}

